package ch.std.jumpstart;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.WebMvcTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;

import ch.std.jumpstart.rest.CityAutoCompleteController;

@WebMvcTest(CityAutoCompleteController.class)
@ActiveProfiles("test")
public class JumpstartApplicationTests {
	@Autowired
	private MockMvc mvc;

	@Test
	public void contextLoads() {
	}

	@Test
	public void testCityAutoCompleteController() throws Exception {
		MvcResult mvcResult = mvc.perform(get("/rest/auto/cities?value=Bern").contentType(MediaType.APPLICATION_JSON))
				.andExpect(status().isOk()).andReturn();
		String expected = "[Bern]";
		String actual = mvcResult.getResponse().getContentAsString();
		JSONAssert.assertEquals(expected, actual, false);
	}
}
