package ch.std.jumpstart.soap;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.annotation.RequestPayload;
import org.springframework.ws.server.endpoint.annotation.ResponsePayload;

import ch.std.jumpstart.jpa.City;
import ch.std.jumpstart.service.CityService;
import ch.std.sbrs.cities.AutoComplete;
import ch.std.sbrs.cities.AutoCompleteResponse;

@Endpoint
public class CityEndpoint {
	private static final String NAMESPACE_URI = "http://www.std.ch/sbrs/cities";

	private CityService cityService;

	@Autowired
	public CityEndpoint(CityService cityService) {
		this.cityService = cityService;
	}

	@PayloadRoot(namespace = NAMESPACE_URI, localPart = "autoComplete")
	@ResponsePayload
	public AutoCompleteResponse autoComplete(@RequestPayload AutoComplete request) {
		AutoCompleteResponse response = new AutoCompleteResponse();
		List<City> cityList = this.cityService.find(request.getValue());
		List<String> cityStringList = response.getCity();
		cityList.forEach(city -> cityStringList.add(city.getName()));
		return response;
	}
}
