package ch.std.jumpstart;

import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;

import ch.std.jumpstart.beans.CitiesBean;
import ch.std.jumpstart.jpa.City;
import ch.std.jumpstart.repository.CityRepository;


@SpringBootApplication
public class JumpstartApplication {

	public static void main(String[] args) {
		SpringApplication.run(JumpstartApplication.class, args);
	}

	@Bean
	@Profile("!test")
	public CommandLineRunner setup(CityRepository repository) {
		return (args) -> {
			for (String city : CitiesBean.getCities()) {
				repository.save(new City(city));				
			}
		};
	}

}
