package ch.std.jumpstart.rest;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SQLController {
	Logger logger = LoggerFactory.getLogger(SQLController.class);
	
	private JdbcTemplate jdbcTemplate;

	public SQLController(JdbcTemplate jdbcTemplate) {
		this.jdbcTemplate = jdbcTemplate;		
	}
	
	@GetMapping("/rest/query")
	public List<?> query(@RequestParam(value = "sql", required = true) String sql) {
		logger.info("query, sql = " + sql);
		List<Map<String, Object>> rows = this.jdbcTemplate.queryForList(sql);
		return rows;
	}
}