package ch.std.jumpstart;

import java.net.InetAddress;
import java.net.URL;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;

@SpringBootApplication
public class JumpstartApplication {

	Logger logger = LoggerFactory.getLogger(JumpstartApplication.class);

	private Environment environment;

	public static void main(String[] args) {
		SpringApplication.run(JumpstartApplication.class, args);
	}

	public JumpstartApplication(Environment environment) {
		this.environment = environment;
	}

	@EventListener(ApplicationReadyEvent.class)
	public void OnApplicationReadyEvent(ApplicationReadyEvent event) {
		try {
			int port = environment.getProperty("server.port", Integer.class, 8080);
			String host = InetAddress.getLocalHost().getHostName();
			String contextPath = environment.getProperty("server.servlet.contextPath", String.class, "/");
			String protocol = "http";
			URL accessURL = new URL(protocol, host, port, contextPath);
			logger.info("Access URL = " + accessURL);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}
}
