package ch.std.jumpstart.tasks.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;

import ch.std.jumpstart.tasks.Taskable;

public class InitialTask implements Taskable {
	Logger logger = LoggerFactory.getLogger(InitialTask.class);

	private JdbcTemplate jdbcTemplate;

	public InitialTask(JdbcTemplate jdbcTemplate) {
		this.jdbcTemplate = jdbcTemplate;
	}

	public void run() {
		try {
			logger.info("IntialTask.run start");
			// read books csv and load them into database
			File csvFile = new ClassPathResource("books.csv").getFile();
			CsvMapper mapper = new CsvMapper();
			CsvSchema schema = CsvSchema.emptySchema().withColumnSeparator(';').withHeader(); // use first row semikolon
																								// as separator and
																								// header; otherwise
																								// defaults are fine
			MappingIterator<Map<String, String>> it = mapper.readerFor(Map.class).with(schema).readValues(csvFile);
			while (it.hasNext()) {
				Map<String, String> rowAsMap = it.next();
				String isbn = rowAsMap.get("isbn");
				String title = rowAsMap.get("title");
				String description = rowAsMap.get("description");
				String publisher = rowAsMap.get("publisher");
				String author = rowAsMap.get("author");
				Number bookKey = null;
				try {
					SimpleJdbcInsert jdbcInsert = new SimpleJdbcInsert(jdbcTemplate);
					jdbcInsert.withTableName("book").usingGeneratedKeyColumns("id");
					Map<String, Object> parameters = new HashMap<>();
					parameters.put("isbn", isbn);
					parameters.put("title", title);
					parameters.put("description", description);
					parameters.put("publisher", publisher);
					// execute insert
					bookKey = jdbcInsert.executeAndReturnKey(new MapSqlParameterSource(parameters));
					logger.info("InitialTask.run, insert book done using key = " + bookKey);
				} catch (Exception ee) {
					logger.error(ee.getMessage(), ee);
				}
				if (author == null) {
					continue;
				}
				String[] authors = author.split(";");
				for (String localAuthor : authors) {
					Number authorKey = null;
					try {
						SimpleJdbcInsert jdbcInsert = new SimpleJdbcInsert(jdbcTemplate);
						jdbcInsert.withTableName("author").usingGeneratedKeyColumns("id");
						Map<String, Object> parameters = new HashMap<>();
						parameters.put("name", localAuthor);
						authorKey = jdbcInsert.executeAndReturnKey(new MapSqlParameterSource(parameters));
					} catch (Exception ee) {
						logger.error(ee.getMessage(), ee);
					}
					if (bookKey != null && authorKey != null) {
						try {
							SimpleJdbcInsert jdbcInsert = new SimpleJdbcInsert(jdbcTemplate);
							jdbcInsert.withTableName("book_author");
							Map<String, Object> parameters = new HashMap<>();
							parameters.put("fk_book", bookKey);
							parameters.put("fk_author", authorKey);
							jdbcInsert.execute(new MapSqlParameterSource(parameters));
						} catch (Exception ee) {
							logger.error(ee.getMessage(), ee);
						}
					}
				}
			}
			logger.info("IntialTask.run done");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}
}
