package ch.std.jumpstart.repositories;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import ch.std.jumpstart.jpa.City;

public interface CityRepository extends JpaRepository<City, Long> {
	City findByName(String name);

	@Query("SELECT c FROM City c WHERE c.name LIKE %?1%")
	public List<City> findByNameLike(String name);
}