package ch.std.jumpstart.dto;

import java.util.ArrayList;
import java.util.List;

public class BookDTO {

	private Long id;

	private String isbn;

	private String title;

	private String description;

	private String publisher;

    private List<AuthorDTO> authorList;

	public BookDTO() {
		this(null, null, null, null);
	}

	public BookDTO(String isbn) {
		this(isbn, null, null, null);
	}

	public BookDTO(String isbn, String title, String description, String publisher) {
		this.id = null;
		this.isbn = isbn;
		this.title = title;
		this.description = description;
		this.publisher = publisher;
	    this.authorList = new ArrayList<>();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((isbn == null) ? 0 : isbn.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		BookDTO other = (BookDTO) obj;
		if (isbn == null) {
			if (other.isbn != null)
				return false;
		} else if (!isbn.equals(other.isbn))
			return false;
		return true;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}
	
	public String getIsbn() {
		return isbn;
	}

	public void setIsbn(String isbn) {
		this.isbn = isbn;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getDescription() {
		return description;
	}

	public String getPublisher() {
		return publisher;
	}

	public void setPublisher(String publisher) {
		this.publisher = publisher;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public List<AuthorDTO> getAuthorList() {
		return authorList;
	}

	public void setAuthorList(List<AuthorDTO> authorList) {
		this.authorList = authorList;
	}
	
	@Override
	public String toString() {
		return "BookDTO [id=" + id + ", isbn=" + isbn + ", title=" + title + ", description=" + description
				+ ", publisher=" + publisher + "]";
	}
	

}
