package ch.std.jumpstart.repositories;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import ch.std.jumpstart.jpa.Author;
import ch.std.jumpstart.jpa.Book;

@RunWith(SpringRunner.class)
@DataJpaTest
@ActiveProfiles("test")
public class BookAuthorRepositoryJPATest {
	
	  @Autowired private BookRepository bookRepository;
	  @Autowired private AuthorRepository authorRepository;
	  private Book book;
	  private Author author;
	  @Before
	  public void setup() {
	    book = new Book("978-1617292545", "this is the title", "that's the description", "my publisher");
	    author = new Author("my author");
	    author.getBookList().add(book);
	    book.getAuthorList().add(author);
	    this.bookRepository.save(book);
	    this.authorRepository.save(author);
	  }

	  @Test
	  public void testFindByAuthorName() {
	    List<Book> foundBookList = this.bookRepository.findByAuthorList_Name("my author");
	    assertNotNull(foundBookList);
	    assertEquals(1, foundBookList.size());
	  }

}
