package ch.std.jumpstart.integration;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.SpringBootTest.WebEnvironment;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.core.env.Environment;
import org.springframework.test.context.junit4.SpringRunner;

import ch.std.jumpstart.jpa.City;
import ch.std.jumpstart.repositories.CityRepository;

@RunWith(SpringRunner.class)
@SpringBootTest(webEnvironment = WebEnvironment.RANDOM_PORT)
@EntityScan(basePackages = "ch.std.jumpstart")
public class JumpstartApplicationJpaTests {
	@LocalServerPort
	private int port;

	@Autowired
	Environment environment;

	@Autowired
	private TestRestTemplate restTemplate;

	@Autowired
	private CityRepository cityRepository;

	@Before
	public void setup() {
		City city = new City();
		city.setName("Bern");
		this.cityRepository.save(city);
	}

	@After
	public void tearDown() {
		this.cityRepository.deleteAll(); // achtung löscht jede instanz einzeln
	}

	@Test
	public void contextLoads() {
	}

	@Test
	public void testCityAutoCompleteController() throws Exception {
		String contextPath = environment.getProperty("server.servlet.contextPath", String.class, "/");
		String url = "http://localhost:" + port + contextPath + "/rest/auto/citiesjpa?value=Bern";
		City[] cities = this.restTemplate.getForObject(url, City[].class);
		assertNotNull(cities);
		assertEquals(1, cities.length);
		City city = cities[0];
		assertNotNull(city);
		assertEquals("Bern", city.getName());
	}
}