package ch.std.jumpstart.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

import ch.std.jumpstart.jpa.Book;
import ch.std.jumpstart.repositories.BookRepository;

@Service
public class BookService {
	
	@Autowired
	private BookRepository bookRepository;

	public List<Book> getBooks(String value) {
		if (value == null) {
			return bookRepository.findAll();
		} else {
			return bookRepository.findAllContaining(value);
		}
	}

	public Book getBookById(Long id) throws BookNotFoundException {
		return bookRepository.findById(id).orElseThrow(() -> new BookNotFoundException(id));
	}

	public Book getBookByIsbn(@RequestParam String isbn) throws BookNotFoundException {
		return bookRepository.findByIsbn(isbn).orElseThrow(() -> new BookNotFoundException(isbn));
	}

	public Book createBook(Book book) {
		// check if book already exists
		Book existingBook = bookRepository.findByIsbn(book.getIsbn()).orElse(null);
		if (existingBook != null) {
			return existingBook;
		}
		bookRepository.save(book);
		return book;
	}

	public Book updateBook(Book book, Long id) {
		Book updatedBook = bookRepository.findById(id).map(existingBook -> {
			existingBook.setIsbn(book.getIsbn());
			existingBook.setTitle(book.getTitle());
			existingBook.setDescription(book.getDescription());
			existingBook.setPublisher(book.getPublisher());
			return bookRepository.save(existingBook);
		}).orElseGet(() -> {
			return bookRepository.save(book);
		});
		return updatedBook;
	}
	
	public void deleteBookById(Long id) throws Exception {
		bookRepository.deleteById(id);
	}

	public static class BookNotFoundException extends RuntimeException {

		/**
		 * 
		 */
		private static final long serialVersionUID = -2478980626272442162L;

		public BookNotFoundException(Long id) {
			super("Could not find book with id " + id);
		}
		
		public BookNotFoundException(String isbn) {
			super(isbn);
		}

	}

}
