package ch.std.jumpstart.rest;

import java.util.List;

import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ch.std.jumpstart.dto.BookDTO;
import ch.std.jumpstart.jpa.Book;
import ch.std.jumpstart.service.BookService;

@RestController
@RequestMapping("/rest")
public class BookController {

	Logger logger = LoggerFactory.getLogger(BookController.class);

	@Autowired
	BookService bookService;

	@Autowired
	private ModelMapper modelMapper;

	@GetMapping("/books")
	public BookDTO[] getBooks(@RequestParam(value = "value", required = false) String value) {
		logger.info("getBooks, value = " + value);
		List<Book> books = this.bookService.getBooks(value);
		BookDTO[] bookArray = books.stream().map(book -> this.modelMapper.map(book, BookDTO.class)).toArray(BookDTO[]::new);
		return bookArray;
	}

	@GetMapping("/book/{id}")
	public BookDTO getBookById(@PathVariable Long id) {
		logger.info("getBookById, id = " + id);
		return this.modelMapper.map(this.bookService.getBookById(id), BookDTO.class);
	}

	@GetMapping("/book")
	public BookDTO getBookByIsbn(@RequestParam String isbn) {
		logger.info("getBookByIsbn, isbn = " + isbn);
		return this.modelMapper.map(this.bookService.getBookByIsbn(isbn), BookDTO.class);
	}

	@PostMapping("/book")
	public BookDTO createBook(@RequestBody BookDTO bookDTO) {
		logger.info("createBook bookDTO = " + bookDTO);
		Book book = this.bookService.createBook(this.modelMapper.map(bookDTO, Book.class));
		return this.modelMapper.map(book, BookDTO.class);
	}

	@PutMapping("/book/{id}")
	public BookDTO updateBook(@RequestBody BookDTO bookDTO, @PathVariable Long id) {
		Book book = this.bookService.createBook(this.modelMapper.map(bookDTO, Book.class));
		return this.modelMapper.map(book, BookDTO.class);
	}

	@DeleteMapping("/book/{id}")
	public ResponseEntity<?> deleteBookById(@PathVariable Long id) {
		logger.info("deleteCityById, id = " + id);
		try {
			this.bookService.deleteBookById(id);
			return new ResponseEntity<>(id, HttpStatus.OK);
		} catch (Exception e) {
			return new ResponseEntity<>(id, HttpStatus.NOT_FOUND);
		}
	}

}
