package ch.std.jumpstart.jpa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

@Entity
@Table(name = "book")
public class Book implements Serializable {

	private static final long serialVersionUID = -244939741845005070L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@Column(name = "isbn", unique = true, length = 32)
	private String isbn;

	@Column(name = "title", length = 256)
	private String title;

	@Column(name = "description", length = 1024)
	private String description;

	@Column(name = "publisher", length = 256)
	private String publisher;

	@ManyToMany
	  @JoinTable(name="book_author",
	  joinColumns = { @JoinColumn(name="fk_book") },
	  inverseJoinColumns = { @JoinColumn(name="fk_author")})
	  private List<Author> authorList;

	public Book() {
		this(null, null, null, null);
	}

	public Book(String isbn) {
		this(isbn, null, null, null);
	}

	public Book(String isbn, String title, String description, String publisher) {
		this.id = null;
		this.isbn = isbn;
		this.title = title;
		this.description = description;
		this.publisher = publisher;
	    this.authorList = new ArrayList<>();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((isbn == null) ? 0 : isbn.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Book other = (Book) obj;
		if (isbn == null) {
			if (other.isbn != null)
				return false;
		} else if (!isbn.equals(other.isbn))
			return false;
		return true;
	}

	public Long getId() {
		return id;
	}

	public String getIsbn() {
		return isbn;
	}

	public void setIsbn(String isbn) {
		this.isbn = isbn;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getDescription() {
		return description;
	}

	public String getPublisher() {
		return publisher;
	}

	public void setPublisher(String publisher) {
		this.publisher = publisher;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public List<Author> getAuthorList() {
		return authorList;
	}
	
	@Override
	public String toString() {
		return "Book [id=" + id + ", isbn=" + isbn + ", title=" + title + ", description=" + description
				+ ", publisher=" + publisher + "]";
	}

}
