/*
 * Decompiled with CFR 0.152.
 */
package ch.std.jumpstart.service;

import ch.std.jumpstart.jpa.Book;
import ch.std.jumpstart.repositories.BookRepository;
import ch.std.jumpstart.service.BookService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class BookService {
    @Autowired
    private BookRepository bookRepository;

    public List<Book> getBooks(String value) {
        if (value == null) {
            return this.bookRepository.findAll();
        }
        return this.bookRepository.findAllContaining(value);
    }

    public Book getBookById(Long id) throws BookNotFoundException {
        return (Book)this.bookRepository.findById(id).orElseThrow(() -> new BookNotFoundException(id));
    }

    public Book getBookByIsbn(@RequestParam String isbn) throws BookNotFoundException {
        return (Book)this.bookRepository.findByIsbn(isbn).orElseThrow(() -> new BookNotFoundException(isbn));
    }

    public Book createBook(Book book) {
        Book existingBook = this.bookRepository.findByIsbn(book.getIsbn()).orElse(null);
        if (existingBook != null) {
            return existingBook;
        }
        this.bookRepository.save((Object)book);
        return book;
    }

    public Book updateBook(Book book, Long id) {
        Book updatedBook = this.bookRepository.findById(id).map(existingBook -> {
            existingBook.setIsbn(book.getIsbn());
            existingBook.setTitle(book.getTitle());
            existingBook.setDescription(book.getDescription());
            existingBook.setPublisher(book.getPublisher());
            return (Book)this.bookRepository.save(existingBook);
        }).orElseGet(() -> (Book)this.bookRepository.save((Object)book));
        return updatedBook;
    }

    public void deleteBookById(Long id) throws Exception {
        this.bookRepository.deleteById((Object)id);
    }
}

