/*
 * Decompiled with CFR 0.152.
 */
package ch.std.jumpstart.rest;

import ch.std.jumpstart.dto.BookDTO;
import ch.std.jumpstart.jpa.Book;
import ch.std.jumpstart.service.BookService;
import java.util.List;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest"})
public class BookController {
    Logger logger = LoggerFactory.getLogger(BookController.class);
    @Autowired
    BookService bookService;
    @Autowired
    private ModelMapper modelMapper;

    @GetMapping(value={"/books"})
    public BookDTO[] getBooks(@RequestParam(value="value", required=false) String value) {
        this.logger.info("getBooks, value = " + value);
        List books = this.bookService.getBooks(value);
        return (BookDTO[])books.stream().map(book -> (BookDTO)this.modelMapper.map(book, BookDTO.class)).toArray(BookDTO[]::new);
    }

    @GetMapping(value={"/book/{id}"})
    public BookDTO getBookById(@PathVariable Long id) {
        this.logger.info("getBookById, id = " + id);
        return (BookDTO)this.modelMapper.map((Object)this.bookService.getBookById(id), BookDTO.class);
    }

    @GetMapping(value={"/book"})
    public BookDTO getBookByIsbn(@RequestParam String isbn) {
        this.logger.info("getBookByIsbn, isbn = " + isbn);
        return (BookDTO)this.modelMapper.map((Object)this.bookService.getBookByIsbn(isbn), BookDTO.class);
    }

    @PostMapping(value={"/book"})
    public BookDTO createBook(@RequestBody BookDTO bookDTO) {
        this.logger.info("createBook bookDTO = " + bookDTO);
        Book book = this.bookService.createBook((Book)this.modelMapper.map((Object)bookDTO, Book.class));
        return (BookDTO)this.modelMapper.map((Object)book, BookDTO.class);
    }

    @PutMapping(value={"/book/{id}"})
    public BookDTO updateBook(@RequestBody BookDTO bookDTO, @PathVariable Long id) {
        Book book = this.bookService.createBook((Book)this.modelMapper.map((Object)bookDTO, Book.class));
        return (BookDTO)this.modelMapper.map((Object)book, BookDTO.class);
    }

    @DeleteMapping(value={"/book/{id}"})
    public ResponseEntity<?> deleteBookById(@PathVariable Long id) {
        this.logger.info("deleteCityById, id = " + id);
        try {
            this.bookService.deleteBookById(id);
            return new ResponseEntity((Object)id, HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)id, HttpStatus.NOT_FOUND);
        }
    }
}

