/*
 * Decompiled with CFR 0.152.
 */
package ch.std.jumpstart.jpa;

import ch.std.jumpstart.jpa.Book;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

@Entity
@Table(name="author")
public class Author
implements Serializable {
    private static final long serialVersionUID = -6490661089934784949L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="name", length=256)
    private String name;
    @ManyToMany(mappedBy="authorList")
    private List<Book> bookList;

    public Author() {
        this(null);
    }

    public Author(String name) {
        this.name = name;
        this.bookList = new ArrayList();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Author other = (Author)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnoreProperties(value={"authorList"})
    public List<Book> getBookList() {
        return this.bookList;
    }

    public String toString() {
        return "Author [id=" + this.id + ", name=" + this.name + "]";
    }
}

