/*
 * Decompiled with CFR 0.152.
 */
package ch.std.jumpstart;

import java.net.InetAddress;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;

@SpringBootApplication
public class JumpstartApplication {
    Logger logger = LoggerFactory.getLogger(JumpstartApplication.class);
    @Autowired
    private Environment environment;

    public static void main(String[] args) {
        SpringApplication.run(JumpstartApplication.class, (String[])args);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void OnApplicationReadyEvent(ApplicationReadyEvent event) {
        try {
            String ip = InetAddress.getLocalHost().getHostAddress();
            int port = (Integer)this.environment.getProperty("server.port", Integer.class, (Object)8080);
            String host = InetAddress.getLocalHost().getHostName();
            String contextPath = (String)this.environment.getProperty("server.servlet.contextPath", String.class, (Object)"/");
            String protocol = "http";
            URL accessURL = new URL(protocol, host, port, contextPath);
            this.logger.info("Access URL = " + accessURL);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

