package ch.std.consoleapp;

import java.util.Arrays;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class ConsoleappApplication implements CommandLineRunner {

	public static Logger logger = LoggerFactory.getLogger(ConsoleappApplication.class);

	public static void main(String[] args) {
		SpringApplication.run(ConsoleappApplication.class, args);
	}

	@Override
	public void run(String... args) throws Exception {
		logger.info("CityConsoleApplication.run begin");
		logger.info("CityConsoleApplication.run end");
	}

	@Bean
	public CommandLineRunner commandLineRunner(ApplicationContext ctx) {
		return args -> {
			System.out.println("CityConsoleApplication.commandLineRunner begin");
			String[] beanNames = ctx.getBeanDefinitionNames();
			Arrays.sort(beanNames);
			for (String beanName : beanNames) {
				logger.info("Bean name = " + beanName);
			}
			logger.info("CityConsoleApplication.commandLineRunner end");
		};
	}

}
